//
//  MCPGDaemon.h
//  MCClientServer
//
//  Created by Brent Gulanowski on 10-02-09.
//  Copyright 2010 Marketcircle Inc. All rights reserved.
//


#import <MCClientServer/MCDaemon.h>


/*
 * This daemon starts up postgres when it starts, and optionally shuts it down IF it started it AND -stopServerWhenFinished returns YES.
 * Make sure to invoke -setup and -cleanup from your subclass.
 *
 */


@interface NSObject (MCDBServer)
- (BOOL)isRunning;
- (BOOL)startAndReturnError:(NSError**)error;
@end

@class MCObjectContextPool, MCHostingNode;

@interface MCDBDaemon : MCDaemon {
	
	MCObjectContextPool *objectContextPool;
	MCHostingNode * hostingNode;
@private
	//NSAutoreleasePool *pgPool; WTF!
	int realStdOut;
	BOOL supressStartupLogs;
	BOOL startedServer;
}

@property (nonatomic, retain) MCObjectContextPool *objectContextPool;
@property (nonatomic, retain) MCHostingNode *hostingNode;

//@property (nonatomic, assign) NSAutoreleasePool *pgPool;
@property (nonatomic) BOOL supressStartupLogs;

/*
 * subclasses should override the following to change the behaviour of the -setup and -cleanup methods (so db server is started/stopped as needed)
 */

// return the appropriate server controller (aka MCPGServer or subclass for the foreseeable future) for starting/stopping
- (id)databaseServer;
// defaults to YES
- (BOOL)safeToStartServer;
// defaults to YES
- (BOOL)safeToStopServer;
// default does nothing
- (BOOL)stopServer:(NSError **)perror;

- (BOOL)supportsHosting;                    // default is YES; mirrord and configd return NO

@end
